/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.bean;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import com.gprinter.utils.CallbackListener;
import com.gprinter.utils.Command;
import com.gprinter.utils.ConnMethod;

public class PrinterDevices {
    private Context context;
    private int id;
    private ConnMethod connMethod;
    private String macAddress;
    private String blueName;
    private UsbDevice usbDevice;
    private String ip;
    private int port;
    private String serialPortPath;
    private int baudRate;
    private Handler handler;
    private int ble;
    private Command command;
    private boolean isSafety;
    private CallbackListener callbackListener;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ConnMethod getConnMethod() {
        return this.connMethod;
    }

    public void setConnMethod(ConnMethod connMethod) {
        this.connMethod = connMethod;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getBlueName() {
        return this.blueName;
    }

    public void setBlueName(String blueName) {
        this.blueName = blueName;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public void setUsbDevice(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getSerialPortPath() {
        return this.serialPortPath;
    }

    public void setSerialPortPath(String serialPortPath) {
        this.serialPortPath = serialPortPath;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public int getBle() {
        return this.ble;
    }

    public void setBle(int ble) {
        this.ble = ble;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isSafety() {
        return this.isSafety;
    }

    public void setSafety(boolean safety) {
        this.isSafety = safety;
    }

    public CallbackListener getCallbackListener() {
        return this.callbackListener;
    }

    public void setCallbackListener(CallbackListener callbackListener) {
        this.callbackListener = callbackListener;
    }

    private PrinterDevices(Build build) {
        this.connMethod = build.connMethod;
        this.macAddress = build.macAddress;
        this.blueName = build.blueName;
        this.port = build.port;
        this.ip = build.ip;
        this.usbDevice = build.usbDevice;
        this.context = build.context;
        this.serialPortPath = build.serialPortPath;
        this.baudRate = build.baudrate;
        this.id = build.id;
        this.handler = build.handler;
        this.callbackListener = build.callbackListener;
        this.command = build.command;
        this.ble = build.ble;
        this.isSafety = build.isSafety;
    }

    public String toString() {
        String str = "";
        str = str + this.connMethod.toString() + "\n";
        switch (this.connMethod) {
            case BLE_BLUETOOTH: 
            case BLUETOOTH: {
                str = str + "Name:\t" + this.blueName + "\nMac:\t" + this.macAddress + "\n";
                break;
            }
            case USB: {
                str = str + this.usbDevice.getDeviceName() + "\npid:\t" + String.format("%04x", this.usbDevice.getProductId()) + " (" + this.usbDevice.getProductId() + ")\nvid:\t" + String.format("%04x", this.usbDevice.getVendorId()) + " (" + this.usbDevice.getVendorId() + ")\n";
                break;
            }
            case UDP: 
            case WIFI: {
                str = str + "ip:\t" + this.ip + "\nport:\t" + this.port + "\n";
                break;
            }
            case SERIALPORT: {
                str = str + "Path:\t" + this.serialPortPath + "\nBaudRate:\t" + this.baudRate + "\n";
            }
        }
        return str;
    }

    public static final class Build {
        private Context context;
        private int id;
        private ConnMethod connMethod;
        private String macAddress;
        private String blueName;
        private UsbDevice usbDevice;
        private String ip;
        private int port;
        private String serialPortPath;
        private int baudrate;
        private Handler handler;
        private CallbackListener callbackListener;
        private Command command;
        private int ble;
        private boolean isSafety;

        public Build setContext(Context context) {
            this.context = context;
            return this;
        }

        public Build setId(int id) {
            this.id = id;
            return this;
        }

        public Build setConnMethod(ConnMethod connMethod) {
            this.connMethod = connMethod;
            return this;
        }

        public Build setMacAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Build setBlueName(String blueName) {
            this.blueName = blueName;
            return this;
        }

        public Build setUsbDevice(UsbDevice usbDevice) {
            this.usbDevice = usbDevice;
            return this;
        }

        public Build setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public Build setPort(int port) {
            this.port = port;
            return this;
        }

        public Build setSerialPort(String serialPortPath) {
            this.serialPortPath = serialPortPath;
            return this;
        }

        public Build setBaudrate(int baudrate) {
            this.baudrate = baudrate;
            return this;
        }

        public Build setHandler(Handler handler) {
            this.handler = handler;
            return this;
        }

        public Build setCommand(Command command) {
            this.command = command;
            return this;
        }

        public Build setBle(int ble) {
            this.ble = ble;
            return this;
        }

        public Build setCallbackListener(CallbackListener callbackListener) {
            this.callbackListener = callbackListener;
            return this;
        }

        public Build setSafety(boolean isSafety) {
            this.isSafety = isSafety;
            return this;
        }

        public PrinterDevices build() {
            return new PrinterDevices(this);
        }
    }
}

